# Cisco Secure Network Analytics Overview

## Key Concept: Network as a Sensor

- Transforms the entire network into a sensor for flow-based visibility.
- Captures all movement (lateral and north-south) in network telemetry.
- Utilizes existing routers and switches to send telemetry data for analysis.

---

# Core Components

## 1. Secure Network Analytics Manager

- Physical or virtual appliance (GUI-based console).
- Aggregates and organizes analysis from flow collectors.
- Presents data via graphical reports, traffic summaries, and integrated security intelligence.
- Coordinates and manages all system appliances (flow collectors and optional components).
- Correlates data in real time and stores it for future analysis.

## 2. Secure Network Analytics Flow Collector

- Physical or virtual appliance.
- Aggregates and normalizes NetFlow data from network devices.
- Provides network visibility and security intelligence.
- Monitors, analyzes, categorizes, and stores flow information.
- Sends alarms to Manager if unusual network activity is detected.
- Multiple collectors can be deployed for large or multi-geo networks.

## 3. Flow Rate License (FPS License)

- Required to aggregate flows at the Manager.
- Defines the maximum volume of flows that can be collected.
- Single license per deployment, based on total flows per second across all collectors.

## 4. Supported Data Types

- Accepts NetFlow, JFlow, sFlow, or IPFIX from any manufacturer’s equipment.
- Ingests NetFlow Secure Event Logging (NSEL) from Cisco Secure Firewall.

---

# User Interfaces

## Manager Administration Consoles

- **Web App**:
    - Main interface for reporting and analytics.
    - Visual, filter-based approach like commercial websites.
- **Desktop Client**:
    - Java-based, provides graphs and tables.
    - Uses legacy Stealthwatch terminology.
    - Being phased out, with functionality moving to Web App.

## Interface Notes

- From version 7.0, host groups and policies can be configured in WebUI.
- Central management of all components is available in WebUI.
- Desktop Client will not support Data Store architecture.

---

# Deployment and Architecture

## Traditional Deployment

- One or more Flow Collectors ingest and analyze telemetry, report to Manager.
- Each Flow Collector stores flow data locally.
- Manager queries Flow Collectors for data, consolidates, and visualizes results.

## Central Data Store Deployment

- Data Store cluster resides between Manager and Flow Collectors.
- Flow Collectors process telemetry, transmit to Data Store for storage.
- Data Store consolidates and evenly distributes flow data for scalability and resiliency.
- Requires Secure Network Analytics version 7.3 or later.
- Web App required for monitoring/configuration with Data Store.

---

# Secure Network Analytics Applications

## Overview

- Introduced in software version 7.0.
- Independently releasable, extend core capabilities.
- Only available in WebUI.
- Apps can be updated separately from the core product.

## Installation

- Download .swu app file compatible with your software version.
- Install via Application Manager in Central Management.
- Apps appear under the Apps menu in WebUI.

## Example Applications

- **Host Classifier**: Dynamic discovery/classification of network assets.
- **Other Apps**: ETA Cryptographic Audit, Network Diagrams, Security Analytics and Logging On Prem, Visibility Assessment.

## Compatibility

- Refer to the Secure Network Analytics Apps Version Compatibility Matrix before installation.

---

# Additional Notes

- Flow Collectors do not need to be inline with network traffic; only IP reachability is required.
- A single Flow Rate License covers all collectors in a deployment, sized to total flow volume.
- Secure Network Analytics supports integration with various vendors’ flow technologies.

---

## Example Summary Table

|Component|Purpose|Deployment Notes|
|---|---|---|
|Manager|Analysis & visualization console|Required|
|Flow Collector|Aggregates & normalizes flow data|Multiple can be deployed|
|Flow Rate License|Controls maximum flows per second|Single license per deployment|
|Data Store (optional)|Centralized, scalable flow data storage|Requires version 7.3+, Web App required|
|Applications|Extend analytics capabilities|WebUI only, update independently|

---

**For latest compatibility and app information, always refer to Cisco documentation.**